/*****************************************************************************
 * Copyright (c) 2019, Nations Technologies Inc.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/

/**
 * @brief 㷨ͷļ.
 * :(TIMER->صAPI->ʼ->)
 * @file n32xx_tsc_alg_api.h
 * @author Nations
 * @version v1.0.1
 * @copyright Copyright (c) 2019, Nations Technologies Inc. All rights reserved.
 */
#ifndef __N32XX_TSC_ALG_API__
#define __N32XX_TSC_ALG_API__

#ifdef __cplusplus
extern "C" {
#endif // defined __cplusplus

#define TSC_ALG_VERSION_NUMBER "Ver1.0.4" //㷨汾

#define TSC_ALG_HANDLER_STOP2_DATA_SIZE (144)  //STOP2ģʽ±津ػѹصTSCݡ
#define TSC_ALG_HANDLER_PERIOD_PER_CHN  (400)  //㷨ͨĴӡ
#define TSC_ALG_WAKEUP_TIMES            (1000) //йTSCѹܵʱãҪ޸
#define TSC_ALG_DEBUG_BUF_SIZE          (260)  //ģʽµBUFС
#define TSC_ALG_REF_SIZE_PER_CHN        (430)  //ÿͨĲοСʵʴСtsc_alg_need_sramsize()Ϊ׼

/**
 * @brief 崥
 */
typedef enum tsc_alg_type_e
{
    TSC_ALG_BUTTON_TYPE = 0, ///< tsc application of simple button
    TSC_ALG_TYPE_MAX         ///<
} tsc_alg_type;

/**
 * @brief ¼
 */
typedef enum tsc_press_key_event_e
{
    TSC_PRESS_KEY_NORMAL = 0, //̰¼
    TSC_PRESS_KEY_MAX         ///<
} tsc_press_key_event;

/**
 * @brief Ͷ
 */
typedef enum tsc_ret_code_e
{
    TSC_SUCCESS = 0,               ///< ɹ
    TSC_NOT_INIT_ERR,              ///< ģδʼ
    TSC_NOT_REG_CHN_ERR,           ///< ģעЧĴͨ
    TSC_NOT_ACCORD_LIB_ERR,        ///< 㷨汾
    TSC_POINTER_NULL_ERR,          ///< ָΪմ
    TSC_PARAM_ZERO_ERR,            ///< 
    TSC_REPEAT_REG_ERR,            ///< ظע
    TSC_CHN_NUM_ERR,               ///< ʼͨһ´
    TSC_REG_CHANNEL_ENOUGH_ERR,    ///< עͨŴ򳬳ϵͳͨ
    TSC_REG_TIMX_ERR,              ///< עTimerԴ
    TSC_REG_DMA_ERR,               ///< עDMAԴ
    TSC_SOURCE_NOT_ENOUGH_ERR,     ///< Դ
    TSC_NOT_SUPPORT_ERR,           ///< δʵִֻ֧
    TSC_LEVEL_CFG_ERR,             ///< ͨô
    TSC_AUTO_CALIB_TIMER_ERR,      ///< ԶУ׼ʱС2ͨʱ.
    TSC_DISTURB_ERR,               ///< Ŵ.
    TSC_CHN_RAM_NOT_ENOUGH_ERR,    ///< ṩTSCͨRAMΪNULLռ䲻
    TSC_STOP2_NULL_OR_INVALID_ERR, ///< ṩStop2DataݿռΪNULL16K retentionڡ
    TSC_DEBUG_BUF_ENOUGH_ERR       ///< ṩĵԻռ䲻
} tsc_ret_code;

/**
 * @brief ذȼ
 * ȼԽС:ӦٶԽ죬˲ĸҲԽ
 * ȼԽ:Ӧٶ˲Խǿ
 */
typedef enum tsc_hld_lev_e
{
    TSC_HOLD_LEV1  = 1,  // HOLDȼ1(5ms)
    TSC_HOLD_LEV2  = 2,  // HOLDȼ2(7ms)
    TSC_HOLD_LEV3  = 3,  // HOLDȼ3(11ms)
    TSC_HOLD_LEV4  = 4,  // HOLDȼ4(17ms)
    TSC_HOLD_LEV5  = 5,  // HOLDȼ5(25ms)
    TSC_HOLD_LEV6  = 6,  // HOLDȼ6(35ms)
    TSC_HOLD_LEV7  = 7,  // HOLDȼ7(47ms)
    TSC_HOLD_LEV8  = 8,  // HOLDȼ8(61ms)
    TSC_HOLD_LEV9  = 9,  // HOLDȼ9(77ms)
    TSC_HOLD_LEV10 = 10, // HOLDȼ10(95ms)
    TSC_HOLD_LEV11 = 11, // HOLDȼ11(115ms)
    TSC_HOLD_LEV12 = 12, // HOLDȼ12(137ms)
    TSC_HOLD_LEV13 = 13, // HOLDȼ13(161ms)
    TSC_HOLD_LEV14 = 14, // HOLDȼ14(187ms)
    TSC_HOLD_LEV15 = 15, // HOLDȼ15(215ms)
    TSC_HOLD_LEV16 = 16, // HOLDȼ16(245ms)
    TSC_HOLD_LEV17 = 17, // HOLDȼ17(277ms)
    TSC_HOLD_LEV18 = 18, // HOLDȼ18(311ms)
    TSC_HOLD_LEV19 = 19, // HOLDȼ19(347ms)
    TSC_HOLD_LEV20 = 20, // HOLDȼ20(385ms)
    TSC_HOLD_MAX         ///< Ч
} tsc_hld_lev;

/**
 * @brief ڵ͹ģʽ£滷仯»ޡ
 * һ仯ӡ
 * Сڴ˱仯ӵdeltaΪЧ仯ͨ˽ӿڸTSCޣ
 * ڴ˱仯ӵdeltaΪЧ仯˽ӿں֮»ޡ
 * 仯Խʾ仯ԽһΪLEV15
 */
typedef enum tsc_delta_limit_lev_e
{
    TSC_DELTA_LIMIT_LEV1  = 1,  //
    TSC_DELTA_LIMIT_LEV2  = 2,  //
    TSC_DELTA_LIMIT_LEV3  = 3,  //
    TSC_DELTA_LIMIT_LEV4  = 4,  //
    TSC_DELTA_LIMIT_LEV5  = 5,  //
    TSC_DELTA_LIMIT_LEV6  = 6,  //
    TSC_DELTA_LIMIT_LEV7  = 7,  //
    TSC_DELTA_LIMIT_LEV8  = 8,  //
    TSC_DELTA_LIMIT_LEV9  = 9,  //
    TSC_DELTA_LIMIT_LEV10 = 10, //
    TSC_DELTA_LIMIT_LEV11 = 11, //
    TSC_DELTA_LIMIT_LEV12 = 12, //
    TSC_DELTA_LIMIT_LEV13 = 13, //
    TSC_DELTA_LIMIT_LEV14 = 14, //
    TSC_DELTA_LIMIT_LEV15 = 15, //
    TSC_DELTA_LIMIT_LEV16 = 16, //
    TSC_DELTA_LIMIT_LEV17 = 17, //
    TSC_DELTA_LIMIT_LEV18 = 18, //
    TSC_DELTA_LIMIT_LEV19 = 19, //
    TSC_DELTA_LIMIT_LEV20 = 20, //
    TSC_DELTA_LIMIT_MAX         ///< Ч
} tsc_delta_limit_lev;

/**
 * @brief ŵȼ
 * ŵȼ,ȼԽ߿ԽǿҲ԰弶ҪԽϿ.
 */
typedef enum tsc_resist_disturb_lev_e
{
    TSC_RESIST_DIS_LEV0 = 0, //Ĭϵȼⲿһ㡣֧PCBA&ǿ
    TSC_RESIST_DIS_LEV1 = 1, //ǿȼⲿǿǿá
    TSC_RESIST_DIS_LEV2 = 2, //ݱ
    TSC_RESIST_DIS_MAX       ///< Ч
} tsc_resist_disturb_lev;

/**
 * @brief TSCͨʼֵ
 */
typedef struct TSC_AlgInitThreValue_t
{
    uint16_t hold_level;     /* ȼ */
    uint16_t rate_of_change; /* ͨ仯(ѹΪ70,ѹΪ77仯Ϊ(77-70)/70 = 0.1%10(ע:ʵΪ8%)ĬΪ5,仯%5 */
    uint32_t chn;            /* ͨ */
} TSC_AlgInitThreValue;

/**
 * @brief TSCʼò
 */
typedef struct TSC_AlgInitTypeDef_t
{
    TIM_Module* TIMx;                      /* 㷨ʹõTIMERԴ(֧TIMER2) */
    DMA_ChannelType* DMAyChx;              /* 㷨ʹõDMAԴ(֧DMA1_CH5) */
    uint32_t DMARemapEnable;               /* ǷʹDMA ȫREMAP(DMA1ͨʹREMAPܣ˴Ϊ1) */
    TSC_AlgInitThreValue* pTScChannelList; /* ɴͨб顣Ŀǰ֧1(ͨλ,TSCͨһб) */
    uint32_t AutoCalibrateTimer;           /* иµԶУ׼ʱ(޸ʱУ׼),һ1000ms,65535λmsֵڰʱ2ϣʼ */
    uint32_t ResistDisturbLev;             /* ŵȼ(tsc_resist_disturb_lev),ȼԽ߿ԽǿҲ԰弶װ价ҪԽ. */
    uint8_t* pTscSramAddr;                 /* ӦóṩTSCĴͨRAMռַ*/
    uint32_t TscSramSize;                  /* ӦóṩTSCĴͨRAMռС.λ(bytes) */
    uint16_t* LogBuf;                      /* ڵģʽµbuf,ǵģʽΪ0 */
    uint16_t LogBufSize;                   /* ÿͨСΪu16 * 256.λ(bytes) */
    uint8_t* Stop2Data;                    /* STOP2ģʽ±津ػѹصTSCBUF */
    uint16_t Stop2DataSize;                /* STOP2ģʽ±津ػѹصTSCBUFСλ(bytes) */
} TSC_AlgInitTypeDef;

/**
 * @brief 㷨ʵʱ(TIMERжϺ)
 * @TIMERʱڲοӣʱڲοDEMO.
 * @param void
 * @return void
 */
void tsc_alg_analyze_handler(void);

/**
 * @brief ͹У׼
 * @param uint32_t delta_limit_level 仯ֵȼtsc_delta_limit_lev
 * @uint32_t hse_or_hsi 0:HSI,  1:HSE;
 * @return
 * - `TSC_SUCCESS ʾɹ
 * - ֵʾ
 * - ע⣺STOP2͹ģʽ£ʱУ׼
 */
int32_t tsc_alg_set_powerdown_calibrate(tsc_delta_limit_lev delta_limit_level, uint32_t hse_or_hsi);

/**
 * @brief ͹ģʽ,Ƿ񱻸Ż
 * @param void
 * @return 0:ѣ1:Ż
 */
int32_t tsc_alg_wakeup_disturb_check(uint32_t* wakeup_src);

/**
 * @brief ȡ㷨汾
 * @param void
 * @return void
 */
char* tsc_alg_get_version(void);

/**
 * @brief 㷨ϵͳδ,Ĭ1ms
 * @param void
 * @return void
 */
void tsc_alg_tick_count(void);

/**
 * @brief ȡTSC㷨ҪSRAMС
 * uint32_t      chn_totals; // ʹõTSCͨ
 * @return
 * - 0:     ʾʧ
 * - 0:  ʾɹ
 */
uint32_t tsc_alg_need_sramsize(uint32_t chn_totals);

/**
 * @brief 㷨ʼ
 * @param tsc_init_parameter *ptsc_init_parameter 㷨ʼṹַ.
 * @param void
 * @return
 * - `TSC_SUCCESS ʾɹ
 * - ֵʾ
 */
int32_t tsc_alg_init(TSC_AlgInitTypeDef* TSC_AlgInitStruct);

/**
 * @brief ؿʼ
 * @param void
 * @return
 * - `TSC_SUCCESS ʾɹ
 * - ֵʾ
 */
int32_t tsc_alg_start(void);

/**
 * @brief TSC͹(ڵ͹Ļģʽ)
 * @param uint32_t TScChannelList Ϊ0ʾʹעͨ
 * @return
 * - `TSC_SUCCESS ʾɹ
 * - ֵʾ
 * - ע⣺STOP2͹ģʽʹãģʽ²ע
 */
int32_t tsc_alg_set_powerdown(uint32_t TscChannelList);

////////////////////////////////////////////////////////////

/*****************ϲӦṩİص*********
 * @brief עᰴť͡͡תʹصĻص
 * @param tsc_touch_type type Ĵ(ְֻ֧)
 * @param uint32_t event 0:¼
 * @param uint32_t chn ʾͨţ
 * @param uint32_t value ״̬1ѹ£0ɿ
 * @return
 * - `TSC_SUCCESS ʾɹ
 * - ֵʾ
 * ע:˻صжеã˾ٻصĴʱ䡣
 ********************************************************/
int32_t tsc_alg_isr_callback(tsc_alg_type type, uint32_t event, uint32_t chn, uint32_t value);

/**
 * @brief PCĽӿڣԱPC˹߹۲죬趨Ĵֵ
 * @param uint32_t chn ͨ
 * @return uint8_t data ôͨ
 */
void tsc_alg_debug_output(uint32_t chn, uint8_t data);

#ifdef __cplusplus
}
#endif // defined __cplusplus

#endif //__N32XX_TSC_ALG_API__
